
markup.push({

	// MARK: label painters

	AlignmentStyles:
    {
		left: 		{ gxHAlign: 0 },
		centerx: 	{ gxHAlign: 0.5 },
		right: 		{ gxHAlign: 1 },
		top: 		{ gxVAlign: 0 },
		centery: 	{ gxVAlign: 0.5 },
		bottom: 	{ gxVAlign: 1 },
		centerxy: 	{ gxHAlign: 0.5, gxVAlign: 0.5 },
	},

	TextStyles:
    {
//		gxFontShadow: "{1, 93, 123, 1}, {0, -1}, 3.0",
//		gxShadow: "{1, 93, 123, 1}, {0, -1}, 3.0",

		// alignment styles. here to ensure LabelFore includes it
		"+": "AlignmentStyles",

		useMarkup: 		{ gxUseInlineMarkup: true },
		stripMarkup: 	{ gxStripInlineMarkup: true },
		
        noIntrinsicWidth:     { gxIntrinsicWidth: -1 },

		// font weights (numbers match apple's naming)
		thinWeight:  	  { gxFontWeight: -0.4 },
		regularWeight:    { gxFontWeight: 0 },
		mediumWeight:     { gxFontWeight: 0.23 },
		boldWeight:       { gxFontWeight: 0.4 },
		
		italic:       	  { gxFontItalic: true },
		
		lineSquash1:	  { gxLineHeightMultiple: 0.875 },
		lineSpacing1:	  { gxLineSpacing: 1 },
		lineSpacing2:	  { gxLineSpacing: 2 },
		lineSpacing3:	  { gxLineSpacing: 3 },
		lineSpacing4:	  { gxLineSpacing: 4 },

        foreColor1: { gxFontColor: "ForeColor1" },
        foreColor2: { gxFontColor: "ForeColor2" },
		foreColor3: { gxFontColor: "ForeColor3" },

        lcdForeColor1: { gxFontColor: "LCDForeColor1" },

        backColor1: { gxFillColor: "BackColor1" },
        backColor2: { gxFillColor: "BackColor2" },

		colorTheme1: { gxFontColor: "ColorTheme1" },
		colorTheme2: { gxFontColor: "ColorTheme2" },
		colorTheme3: { gxFontColor: "ColorTheme3" },

        foreColorTheme1: { 	gxFontColor: "ForeColorTheme1",
								gxFontShadow: "{0, 0, 0, 0.3}, {0, 0}, 2",
						},

        colorThemeLive1: { gxFontColor: "ColorThemeLive1" },
        colorThemeLive2: { gxFontColor: "ColorThemeLive2" },
        
		colorLive1: 	{ gxFontColor: "ColorLive1" },	// always orange

        errorColor:     { gxFontColor: "ErrorColor" },
        
		blockReadout: 	{ 	gxFontColor: "ColorThemeLive3",
							gxFontWeight: 0.23,		// mediumWeight
							gxFontSize: 11,
							gxFontShadow: "{0, 0, 0, 0.3}, {0, 0}, 2",
						},
		
		readout: 		{ 	gxFontColor: "ColorThemeLive2",
							gxFontWeight: 0.23,		// mediumWeight
							gxFontSize: 11,
							gxHAlign: 1,
						},

		axReadable: 	{ axIsIgnored: false, },
		
		// color
        showAnimating:
        {
            animating:	 { gxFontColor: "ColorThemeLive2" },
        },

		showSelected:
		{
			selected:	 { gxFontColor: "ForeColor1" },
		},

		// sizes
		size4:		{ gxFontSize: 4 },
		size8:		{ gxFontSize: 8 },
		size9:		{ gxFontSize: 9 },
		size10:		{ gxFontSize: 10 },
		size105:	{ gxFontSize: 10.5 },
		size11:		{ gxFontSize: 11 },
		size115:	{ gxFontSize: 11.5 },
		size12:		{ gxFontSize: 12 },
		size125:	{ gxFontSize: 12.5 },
		size13:		{ gxFontSize: 13 },
		size135:	{ gxFontSize: 13.5 },
		size14:		{ gxFontSize: 14 },
		size145:	{ gxFontSize: 14.5 },
		size15:		{ gxFontSize: 15 },
		size16:		{ gxFontSize: 16 },
		size18:		{ gxFontSize: 18 },
		size19:		{ gxFontSize: 19 },
		size20:		{ gxFontSize: 20 },
		size21:		{ gxFontSize: 21 },
		size22:		{ gxFontSize: 22 },
		size28:		{ gxFontSize: 28 },

		// word wrap
		wrap: 		{ gxLineBreakMode: 0 },
		clip: 		{ gxLineBreakMode: 2 },
		truncates: 	{ gxTruncatesLastVisibleLine: true },

		icon: {
			nsClass: "GXTextAttachmentCell",
			gxBaselineOffset: -4,
			gxForePainter: "ImagePainter.iconSize18.foreColor1",
		},

		imageButton: {
			nsClass: "GXTextAttachmentCell",
			gxBaselineOffset: -4,
			gxForePainter: "ImageButtonPainter",
		},

		sourceIcon: {
			nsClass: "GXTextAttachmentCell",
			gxBaselineOffset: -5,
			gxForePainter: {
				// avoid using 'ImagePainter' because it allows
				// styles to apply tint color we want to avoid
                nsClass: "GXImagePainter",
                gxTintColor: "ForeColor1",
				gxTrimImage: true,
                noTint: {
                    gxTintColor: null,
					//gxDefaultSize: "24, 24",
					gxEdgeInsets: "0, 1, 0, 1",
                },
				gxDefaultSize: "26, 24",
				smallerSourceIcon:
				{
					gxDefaultSize: "20, 20",
				},
				gxHAlign: 0.5,
				gxVAlign: 0.5,
			}
		},

		presetIcon: {
			nsClass: "GXTextAttachmentCell",
			gxBaselineOffset: -4,
			gxForePainter: {
				// avoid using 'ImagePainter' because it allows
				// styles to apply tint color we want to avoid
				nsClass: "GXImagePainter",
				gxTintColor: "ForeColor1",
				gxTrimImage: true,
				noTint: {
					gxTintColor: null,
					//gxDefaultSize: "24, 24",
					//gxEdgeInsets: "0, 1, 0, 1",
				},
				gxDefaultSize: "20, 18",
				gxHAlign: 0.5,
				gxVAlign: 0.5,
			}
		},

		menuIcon: {	// shortcut for standard size and color
			nsClass: "GXTextAttachmentCell",
			gxForePainter: "ImagePainter.menuIconSize",
		},

		icon12: {    // shortcut for standard size and color
			nsClass: "GXTextAttachmentCell",
			gxBaselineOffset: -2,
			gxForePainter: "ImagePainter.foreColor1.iconSize12",
		},

		icon14: {	// shortcut for standard size and color
			nsClass: "GXTextAttachmentCell",
			gxBaselineOffset: -3,
			gxForePainter: "ImagePainter.foreColor1.iconSize14",
		},
		
		icon16: {	// shortcut for standard size and color
			nsClass: "GXTextAttachmentCell",
			gxBaselineOffset: -4,
			gxForePainter: "ImagePainter.iconSize16",
		},

		disclosure: {
			nsClass: "GXTextAttachmentCell",
			gxForePainter: {
                nsClass: "GXImagePainter",
                gxImage: "disclosure",
                gxTintColor: "ForeColor1",
				gxDefaultSize: "16, 16",
				gxHAlign: 0.5,
				gxVAlign: 0.6,
			}
		},

		checkbox: {
			nsClass: "GXTextAttachmentCell",
			gxBaselineOffset: -4,
			// forepainter size is used as cell size
			gxForePainter: {
                nsClass: "GXImagePainter",
				gxImage: "checkboxTick",
                gxTintColor: "ForeColorTheme1",
				gxEdgeInsets: "0, 0, 1, 0",
				gxDefaultSize: "20, 18",
				gxHAlign: 0.5,
				gxVAlign: 0.5,
			},
			gxBackPainter: {
				"+": "ControlBack",
                gxCornerRadius: 5,
				gxEdgeInsets: "0, 0, 2, 0",
			},
		},

		menuCheckbox: {
			nsClass: "GXTextAttachmentCell",
			gxBaselineOffset: -5,
			// forepainter size is used as cell size
			gxForePainter: {
                nsClass: "GXImagePainter",
				gxImage: "checkboxTick",
                gxTintColor: "ForeColorTheme1",
				gxEdgeInsets: "0, 0, 3, 2",
				gxDefaultSize: "20, 18",
				gxHAlign: 0.5,
				gxVAlign: 0.5,
			},
			gxBackPainter: {
				"+": "ControlBack",
                gxCornerRadius: 5,
                gxFrameColor: "ForeColor2.dimmed",
                on: {
					gxFrameColor: null,
					gxFillColor: "ColorTheme1",
				},
				gxEdgeInsets: "0, 0, 4, 2",
			},
		},

        checkboxSpacer: {   // takes same horizontal space as checkbox,
                            // so it can be inserted to align wrapped text
            nsClass: "GXTextAttachmentCell",
            // forepainter size is used as cell size
            gxForePainter: {
                nsClass: "GXPainter",
                gxEdgeInsets: "0, 0, 2, 0",
                gxDefaultSize: "20, 2",
                gxHAlign: 0.5,
                gxVAlign: 0.5,
            },
        },
        
		radioButton: {
			nsClass: "GXTextAttachmentCell",
			gxBaselineOffset: -4,
			// forepainter size is used as cell size
			gxForePainter: {
                nsClass: "GXCirclePainter",
                on: { gxFillColor: "ForeColorTheme1" },
				gxEdgeInsets: "0, 0, 2, 0",
				gxDefaultSize: "20, 18",
				gxDiameter: 8,
			},
			gxBackPainter: {
				"+": "ControlBack",
                nsClass: "GXCirclePainter",
				gxEdgeInsets: "0, 0, 2, 0",
				gxDiameter: 18,
			},
		},

		plusButton: {
			nsClass: "GXTextAttachmentCell",
			gxBaselineOffset: -5,
			gxForePainter: {
				nsClass: "GXImagePainter",
				gxImage: "action.plus",
				gxTintColor: "ForeColor1",
				disabled: { gxTintColor: "ForeColor2" },
				gxDefaultSize: "20, 20", 	// used as cell size
				gxAlignment: "0.5, 0.5",
			},
			gxBackPainter: {
				"+": "ButtonBack",
				nsClass: "GXCirclePainter",
				gxDiameter: 20,
			},
		},

		minusButton: {
			nsClass: "GXTextAttachmentCell",
			gxBaselineOffset: -5,
			gxForePainter: {
				nsClass: "GXImagePainter",
				gxImage: "action.minus",
				gxTintColor: "ForeColor1",
				disabled: { gxTintColor: "ForeColor2" },
				gxDefaultSize: "20, 20", 	// used as cell size
				gxAlignment: "0.5, 0.5",
			},
			gxBackPainter: {
				"+": "ButtonBack",
				nsClass: "GXCirclePainter",
				gxDiameter: 20,
			},
		},
		
		requiresFile: {
			nsClass: "GXTextAttachmentCell",
			gxBaselineOffset: -4,
			// forepainter size is used as cell size
			gxForePainter: {
				"+": "LabelFore.centerx.size10",
				gxFontColor: "SyntaxRequiresColor",
				gxDefaultString: "File",
				gxDefaultSize: "27, 16",
				gxEdgeInsets: "5, 0, 4, 0",
			},
			gxBackPainter: {
				nsClass: "GXPainter",
				gxCornerRadius: 4,
				gxFrameColor: "SyntaxRequiresColor",
				gxEdgeInsets: "0, 2, 2, 1",
			},
		},

		requiresSession: {
			nsClass: "GXTextAttachmentCell",
			gxBaselineOffset: -4,
			// forepainter size is used as cell size
			gxForePainter: {
				"+": "LabelFore.centerx.size10",
				gxFontColor: "SyntaxRequiresColor",
				gxDefaultString: "Session",
				gxDefaultSize: "48, 16",
				gxEdgeInsets: "5, 0, 4, 0",
			},
			gxBackPainter: {
				nsClass: "GXPainter",
				gxCornerRadius: 4,
				gxFrameColor: "SyntaxRequiresColor",
				gxEdgeInsets: "0, 2, 2, 1",
			},
		},

		requiresTimer: {
			nsClass: "GXTextAttachmentCell",
			gxBaselineOffset: -4,
			// forepainter size is used as cell size
			gxForePainter: {
				"+": "LabelFore.centerx.size10",
				gxFontColor: "SyntaxRequiresColor",
				gxDefaultString: "Timer",
				gxDefaultSize: "37, 16",
				gxEdgeInsets: "5, 0, 4, 0",
			},
			gxBackPainter: {
				nsClass: "GXPainter",
				gxCornerRadius: 4,
				gxFrameColor: "SyntaxRequiresColor",
				gxEdgeInsets: "0, 2, 2, 1",
			},
		},

	},

	// MARK: - image painters

	ImagePainter:
    {
		nsClass: "GXImagePainter",
		gxHAlign: 0.5,
		gxVAlign: 0.5,
            
		// alignment styles
		"+": "AlignmentStyles",

		trimImage:  { gxTrimImage: true },	// only suitable for some images. Used on app icons
		
        iconSize12: { gxDefaultSize: "12, 12" },
		iconSize14: { gxDefaultSize: "14, 14" },
		iconSize16: { gxDefaultSize: "16, 16" },
		iconSize18: { gxDefaultSize: "18, 18" },
        iconSize20: { gxDefaultSize: "20, 20" },
        iconSize22: { gxDefaultSize: "22, 22" },
		menuIconSize: { gxDefaultSize: "22, 16", gxEdgeInsets: "0, 0, 6, 0" },

		tintColor1: 		{ gxTintColor: "ForeColor1" },

        foreColor1: 		{ gxTintColor: "ForeColor1" },
        foreColor2: 		{ gxTintColor: "ForeColor2" },
		foreColor3: 		{ gxTintColor: "ForeColor3" },

        backColor2: 		{ gxTintColor: "BackColor2" },

        colorTheme1:        { gxTintColor: "ColorTheme1" },
		
		colorLive1: 		{ gxTintColor: "ColorLive1" },	// always orange

		colorThemeLive1: 	{ gxTintColor: "ColorThemeLive1" },
		colorThemeLive2: 	{ gxTintColor: "ColorThemeLive2" },
		
		foreColorTheme1: 	{ gxTintColor: "ForeColorTheme1" },

        statusLightColor:  { gxTintColor: "StatusLightColor" },

		alpha30: {
			gxAlpha: 5,
		},
		dimmed: {
			gxAlpha: 70,
		},

		blockDisabled: {
			gxAlpha: 75,
		},

	},

})

